<?php

try {
    if (session_status() === PHP_SESSION_NONE) session_start();
    require './property_settings_essentials.php';
    // print_r($allProperties);
} catch (\Throwable $th) {
    // throw $th;
}
?>


<!-- Tabs Nav -->
<style>
    .table{
        width: 100% !important;
    }    
    .previous{
        display: none !important;
    }
    .next{
        display: none !important;
    }
    .dataTables_info{
        display: none !important;
    }
    .table-responsive {
        overflow-x: hidden !important;
        overflow-y: hidden !important;
    }
</style>
<h5 class="modal-title" id="addEditQrCode"></h5>

<ul class="nav nav-tabs" id="propertyTabs" role="tablist">
    <li class="nav-item">
        <a class="nav-link active" id="doorSettings-tab" data-toggle="tab" href="#doorSettings" role="tab" aria-controls="doorSettings" aria-selected="true">Doors</a>
    </li>
    <li class="nav-item">
        <a class="nav-link" id="cameras-tab" onclick="refreshCameraTable()" data-toggle="tab" href="#cameras" role="tab" aria-controls="cameras" aria-selected="false">Cameras</a>
    </li>
</ul>

<div class="tab-content" id="propertyTabsContent">
    <div class="tab-pane fade show active" id="doorSettings" role="tabpanel" aria-labelledby="doorSettings-tab">
        <script src="../../../js/property_builder/property_settings.js"></script>
        <div class="d-flex justify-content-between">
            <div class="d-flex my-3">
                <button type="button" id="add_Property_setting" class="btn btn-block btn-dark" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#setPermissionsModal" style="margin:1rem 0 1rem 0rem;width:auto;" onclick="settingNewPermissions()"><i class="fa-solid fa-plus"></i> Door Permission</button>
            </div>
        </div>

        <div class="isLoading justify-content-center m-5" style="display: none;" id="property_settings_loading_indicator">
            <img src="/include/images/loader.gif" style="width:100px;margin-left:5px" alt="" srcset="">
        </div>

        <div id="property_settings">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Permissions</h3>
                    <!-- Search bar -->
                    <div class="card-tools">
                        <div class="input-group input-group-sm" style="width: 250px;">
                            <input type="text" id="searchPermissionInput" onkeyup="searchPropertySettings()" class="form-control float-right" placeholder="Search Permission">
                            <div class="input-group-append">
                                <button type="button" class="btn btn-default">
                                    <i class="fas fa-search"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div id="property_settings_table"></div>
                </div>
            </div>
            
        </div>

        <div class="modal fade" id="setPermissionsModal" tabindex="-1" role="dialog" aria-labelledby="setPermissionsModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-area" role="document" style="min-height:90vh">
                <div class="modal-content">
                    <div class="modal-header">

                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <form>
                            <input type="hidden" name="settings_id" id="property_settings_id" value="">
                            <div class="form-group">
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" onchange="handle_individual_change()" id="is_individual_command" checked>
                                    <label class="custom-control-label" for="is_individual_command">Individual</label>
                                </div>
                            </div>

                            <div id="individual_fields">
                                <div class="form-group">
                                    <label for="user_select_id">User*</label>
                                    <select name="type" id="user_select_id" required="required" class="form-control select2bs4" style="width: 100%;">
                                        <option value="" disabled>Select a user</option>
                                    </select>
                                </div>


                                <div class="form-group">
                                    <label for="door_id">Door*</label>
                                    <select name="type" id="door_id" required="required" class="form-control select2bs4" style="width: 100%;">
                                        <option value="" disabled selected>Select a Door</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Global Configuration Message Container -->
                            <div id="global_config_message" style="display: none;"></div>

                            <div class="form-group d-flex flex-wrap" id="commands_button">
                                <div class="custom-control custom-checkbox m-1">
                                    <input class="custom-control-input" type="checkbox" id="release_command" value="release">
                                    <label for="release_command" class="custom-control-label">Release</label>
                                </div>
                                <div class="custom-control custom-checkbox m-1">
                                    <input class="custom-control-input" type="checkbox" id="open_command" value="open" checked>
                                    <label for="open_command" class="custom-control-label">Open</label>
                                </div>
                                <div class="custom-control custom-checkbox m-1">
                                    <input class="custom-control-input" type="checkbox" id="hold_open_command" value="hold_open">
                                    <label for="hold_open_command" class="custom-control-label">Hold Open</label>
                                </div>
                                <div class="custom-control custom-checkbox m-1">
                                    <input class="custom-control-input" type="checkbox" id="keep_open_to_command" value="keep_open_to_command">
                                    <label for="keep_open_to_command" class="custom-control-label">Schedules</label>
                                </div>
                            </div>

                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="button" onclick="getFormValues()" class="btn btn-success">Submit</button>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- ============camera tab=========== -->
    <div class="tab-pane fade" id="cameras" role="tabpanel" aria-labelledby="cameras-tab">
        <div class="d-flex justify-content-between">
            <div class="d-flex my-3">
            <button type="button" id="add_camera_permission" class="btn btn-block btn-dark" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#setPermissionsForCameraModal" style="margin:1rem 0 1rem 0rem;width:auto;" onclick="settingNewPermissionsForCamera()"><i class="fa-solid fa-plus"></i> Camera Permission</button>
            </div>
        </div>

        <div id="property_settings">
            <div id="global_permission_container"></div>
            <div id="property_camera_permissions_table"></div>
        </div>

        <div class="modal fade" id="setPermissionsForCameraModal" tabindex="-1" role="dialog" aria-labelledby="setPermissionsForCameraModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-area" role="document" style="min-height:90vh">
                <div class="modal-content">
                    <div class="modal-header">

                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <form>
                            <input type="hidden" name="property_camera_permissions_id" id="property_camera_permissions_id" value="">
                            <input type="hidden" name="property_global_camera_permissions_id" id="property_global_camera_permissions_id" value="">
                            <div class="form-group">
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" onchange="handle_individual_camera_change()" id="is_individual_camera" checked>
                                    <label class="custom-control-label" for="is_individual_camera">Individual</label>
                                </div>
                            </div>

                            <div id="individual_fields_camera">
                                <div class="form-group">
                                    <label for="user_id_camera">User*</label>
                                    <select name="type" id="user_id_camera" required="required" class="form-control select2bs4" style="width: 100%;">
                                        <option value="" disabled>Select a user</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="camera_id_for_permission">Camera*</label>
                                    <select name="type" id="camera_id_for_permission" required="required" class="form-control select2bs4" style="width: 100%;">
                                        <option value="" disabled selected>Select a camera</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <input  type="checkbox" id="view_permission">
                                    <label for="view_permission">View permission</label>
                                </div>
                            </div>

                            <div class="align-items-center mb-3" id="global_camera_permissions" aria-disabled="" style="display: none;">
                                <p class="mb-0 mt-1 mr-2 px-2">All users have view permissions of</p>
                                <div class="form-group not_show_on_sms mb-0" style="min-width: 250px;">
                                    <label for="multi_camera_select" class="mb-0 mr-2">cameras*</label>
                                    <select class="form-control select2-multi" id="multi_camera_select" multiple name="multi_camera_select">
                                    </select>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="button" onclick="setPermissionsForCamera()" class="btn btn-success">Submit</button>
                    </div>
                </div>
            </div>
        </div>


    </div>
</div>
<div class="toast-container position-fixed p-3" id="settingsToastMessage" style="display:none;z-index: 99999; top: 20px; right: 0px;width:300px">
    <div id="property_settings_Toast" class="toast bg-danger text-white" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="toast-header d-flex justify-content-between  ">
            <strong class="me-auto">Error</strong>
            <button onclick="closeSettingsToastMessage()" type="button" class="close " data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="toast-body" id="settingsErrorToast">
            An error occurred! Please check the details and try again.
        </div>
    </div>
</div>