<?php

try {
    if (session_status() === PHP_SESSION_NONE) session_start();
    
} catch (\Throwable $th) {
    // throw $th;
}
?>


<script src="../../../js/property_builder/streets.js"></script>

<div class="d-flex justify-content-between">
    <h3 class="px-2">Streets</h3>
</div>

<div id="streets_div">

    <div class="d-flex">
        <button type="button" id="add_streets" class="btn btn-block btn-dark" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#streetsmodal" style="margin:1rem 0 1rem 0rem;width:auto;"><i class="fa-solid fa-plus"></i> Streets</button>
    </div>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Streets</h3>
            <!-- Search bar -->
            <div class="card-tools">
                <div class="input-group input-group-sm" style="width: 250px;">
                    <input type="text" id="searchStreetInput" onkeyup="searchStreets()" class="form-control float-right" placeholder="Search Street">
                    <div class="input-group-append">
                        <button type="button" class="btn btn-default">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive" id="streets_display">
            </div>
        </div>
    </div>

</div>

<!-- View template Modal -->

<div class="modal fade" id="streetsmodal" tabindex="-1" role="dialog" aria-labelledby="streetsmodalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="streetsmodalTitle">Add a Street</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="newStreetForm" action="include/property_builder/streets/streets_requests.php" method="post">
                    <div class="input-group mb-3">
                        <input type="text" name="streetname" class="form-control" placeholder="Street Name" required>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fa-solid fa-address-card"></span>
                            </div>
                        </div>
                    </div>
                    <button type="submit" name="submitnewstreet" class="btn btn-primary btn-block">Add Street</button>
                </form>                
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="editstreetsmodal" tabindex="-1" role="dialog" aria-labelledby="editstreetsmodalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editstreetsmodalTitle">Edit Street</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="editStreetForm" action="include/property_builder/streets/streets_requests.php" method="post">
                    <input type="hidden" name="editstreetid" id="editstreetid">
                    <input type="hidden" name="origname" id="origname">
                    <div class="input-group mb-3">
                        <input type="text" name="editstreetname" id="editstreetname" class="form-control" placeholder="Street Name" required>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fa-solid fa-address-card"></span>
                            </div>
                        </div>
                    </div>
                    <button type="submit" name="submiteditstreet" class="btn btn-primary btn-block">Update Street</button>
                </form>              
            </div>
        </div>
    </div>
</div>