<?php
    try {
        session_start();
        //code...
        require '../../db.php';
        require '../auth/auth_functions.php';
        
        if (!currentUserHasAccess($pdo, 'my_iis', 'read')) {
            echo "Access denied.";
            exit();
        }
    } catch (\Throwable $th) {
        // throw $th;
    }
?>

<style>
    /* Custom styles for tab colors */
    .nav-tabs .nav-link {
        color: black;
        /* Default color for inactive tabs */
    }

    .nav-tabs .nav-link.active {
        color: blue;
        /* Color for active tab */
    }

    .nav-tabs .nav-link:hover {
        color: blue;
        /* Hover color for tabs */
    }

    .nav-tabs .nav-link.active {
        background-color: #f8f9fa;
        /* Background color for active tab */
        border-color: #dee2e6 #dee2e6 #fff;
        /* Border color adjustments */
    }
    .max_w{
        max-width: 100% !important;
    }
    
</style>
<div>
    <div class="container max_w">
        <div id="success_message">
            
        </div>
        
        <!-- Tab navigation -->
        <ul class="nav nav-tabs" id="myTab" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" id="purchased-numbers-tab" data-toggle="tab" href="#purchased-numbers" onclick="mySignalwireNumbers()" role="tab" aria-controls="purchased-numbers" aria-selected="true">Purchased Numbers</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="available-numbers-tab" data-toggle="tab" href="#available-numbers" role="tab" aria-controls="available-numbers" aria-selected="false" onclick="searchNumbers('Local', 'search')">Available Numbers</a>
            </li>
            <!-- <li class="nav-item">
                <a class="nav-link" id="access-tab" data-toggle="tab" href="#access" role="tab" aria-controls="access" aria-selected="false">Access Levels</a>
            </li> -->
        </ul>

        <!-- Tab content -->
        <div class="tab-content" id="phoneNUmberTab">
            <div class="tab-pane fade show active" id="purchased-numbers" role="tabpanel" aria-labelledby="purchased-numbers-tab">
                <!-- Content for Doors/Gate -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h3 class="card-title">Purchased Numbers</h3>
                        <div class="card-tools">
                            <div class="input-group input-group-sm" style="width: 250px;">
                                <input type="text" id="searchMyNumbers" onkeyup="searchTable('my_ii_purchased_numbers', 'searchMyNumbers')" class="form-control float-right" placeholder="Search Numbers">
                                <div class="input-group-append">
                                    <button type="button" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <div class="table-responsive"> 
                            <table class="table table-hover table-bordered" id="my_ii_purchased_numbers">
                                <thead>
                                    <tr>
                                        <th>Phone Number</th>
                                        <th>Property</th>
                                        <th>Status</th>
                                        <?php
                                            if(($_SESSION['layer'] == "super_admin") || ($_SESSION['layer'] == "admin")){
                                        ?>
                                            <th>Dealer</th>
                                            <th>Sid</th>
                                            <th>Voice Url</th>
                                            <th>Sms Url</th>
                                        <?php } ?>
                                            <th>Action</th>

                                    </tr>
                                </thead>
                                <tbody id="sgwnumbers">
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
            </div>

            <div class="tab-pane fade " id="available-numbers" role="tabpanel" aria-labelledby="available-numbers-tab">

                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="local-numbers-tab" data-toggle="tab" href="#local-numbers" role="tab" aria-controls="toll-free-numbers" aria-selected="true" onclick="searchNumbers('Local', 'search')">Local</a>
                    </li>
                    <!-- <li class="nav-item">
                        <a class="nav-link" id="toll-free-numbers-tab" data-toggle="tab" href="#toll-free-numbers" role="tab" aria-controls="toll-free-numbers" aria-selected="false" onclick="searchNumbers('TollFree', 'search')">Toll Free</a>
                    </li> -->
                </ul>
                <div class="tab-content" id="phoneNUmberTab">
                    <!-- Content for Hardware -->
                    <div class="tab-pane fade show active" id="local-numbers" role="tabpanel" aria-labelledby="local-numbers-tab">
                        <div class="row mt-4">
                            <div class="col-sm-3">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">Search For Numbers</h3>
                                    </div>
                                    <div class="card-body">
                                        <input type="hidden" name="search_number_type" id="search_number_type" value="Contains">
                                        
                                        <div class="form-group">
                                            <label>Number or Word - Optional</label>
                                            <input type="text" name="search_number_term" class="form-control" id="search_number_term" placeholder="Any" maxlength="7" size="7">
                                        </div>
                                        <div class="form-group">
                                            <label>Area Code - Optional</label>
                                            <input type="text" name="search_number_areacode" class="form-control" placeholder="Any" maxlength="3" size="3" id="search_number_areacode">
                                        </div>
                                        <div class="form-group">
                                            <label>Region - Optional</label>
                                            <select name="search_number_state" id="search_number_state" class="form-control select2bs4" style="width: 100%;" required>
                                                <option value="" selected="selected">Any</option>
                                                <option value="AL">Alabama</option>
                                                <option value="AK">Alaska</option>
                                                <option value="AZ">Arizona</option>
                                                <option value="AR">Arkansas</option>
                                                <option value="CA">California</option>
                                                <option value="CO">Colorado</option>
                                                <option value="CT">Connecticut</option>
                                                <option value="DE">Delaware</option>
                                                <option value="DC">District Of Columbia</option>
                                                <option value="FL">Florida</option>
                                                <option value="GA">Georgia</option>
                                                <option value="HI">Hawaii</option>
                                                <option value="ID">Idaho</option>
                                                <option value="IL">Illinois</option>
                                                <option value="IN">Indiana</option>
                                                <option value="IA">Iowa</option>
                                                <option value="KS">Kansas</option>
                                                <option value="KY">Kentucky</option>
                                                <option value="LA">Louisiana</option>
                                                <option value="ME">Maine</option>
                                                <option value="MD">Maryland</option>
                                                <option value="MA">Massachusetts</option>
                                                <option value="MI">Michigan</option>
                                                <option value="MN">Minnesota</option>
                                                <option value="MS">Mississippi</option>
                                                <option value="MO">Missouri</option>
                                                <option value="MT">Montana</option>
                                                <option value="NE">Nebraska</option>
                                                <option value="NV">Nevada</option>
                                                <option value="NH">New Hampshire</option>
                                                <option value="NJ">New Jersey</option>
                                                <option value="NM">New Mexico</option>
                                                <option value="NY">New York</option>
                                                <option value="NC">North Carolina</option>
                                                <option value="ND">North Dakota</option>
                                                <option value="OH">Ohio</option>
                                                <option value="OK">Oklahoma</option>
                                                <option value="OR">Oregon</option>
                                                <option value="PA">Pennsylvania</option>
                                                <option value="RI">Rhode Island</option>
                                                <option value="SC">South Carolina</option>
                                                <option value="SD">South Dakota</option>
                                                <option value="TN">Tennessee</option>
                                                <option value="TX">Texas</option>
                                                <option value="UT">Utah</option>
                                                <option value="VT">Vermont</option>
                                                <option value="VA">Virginia</option>
                                                <option value="WA">Washington</option>
                                                <option value="WV">West Virginia</option>
                                                <option value="WI">Wisconsin</option>
                                                <option value="WY">Wyoming</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label>City - Optional</label>
                                            <input type="text" name="search_number_city" class="form-control" placeholder="Any" disabled>
                                        </div>
                                        <div class="form-group">
                                            <button onclick="searchNumbers('Local', 'search')" class="form-control btn btn-primary">Search</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-9">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">Local Numbers</h3>
                                        <div class="card-tools">
                                            <div class="input-group input-group-sm" style="width: 250px;">
                                                <input type="text" id="searchMyLocalNumbers" onkeyup="searchTable('available_local_numbers', 'searchMyLocalNumbers')" class="form-control float-right" placeholder="Search Number">
                                                <div class="input-group-append">
                                                    <button type="button" class="btn btn-default">
                                                        <i class="fas fa-search"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /.card-header -->
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-hover table-bordered" id="available_local_numbers" style="width: 100%;">
                                                <thead>
                                                    <tr>
                                                        <th>Friendly Name</th>
                                                        <th>Phone Number</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="localNumbers">
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- /.card-body -->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade " id="toll-free-numbers" role="tabpanel" aria-labelledby="toll-free-numbers-tab">
                        <div class="row mt-4">
                            <div class="col-sm-3">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">Search For Numbers </h3>
                                    </div>
                                    <div class="card-body">
                                        <input type="hidden" name="toll_search_number_type" id="toll_search_number_type" value="Contains">
                                        
                                        <div class="form-group">
                                            <label>Number or Word - Optional</label>
                                            <input type="text" name="toll_search_number_term" class="form-control" id="toll_search_number_term" placeholder="Any" maxlength="7" size="7">
                                        </div>
                                        <div class="form-group">
                                            <button class="form-control btn btn-primary" type="button" onclick="searchNumbers('TollFree', 'search')">Search</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-9">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">Toll Free Numbers</h3>
                                        <div class="card-tools">
                                            <div class="input-group input-group-sm" style="width: 150px;">
                                                <input type="text" name="table_search" class="form-control float-right" placeholder="Search">
                                                <div class="input-group-append">
                                                    <button type="submit" class="btn btn-default">
                                                        <i class="fas fa-search"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /.card-header -->
                                    <div class="card-body table-responsive p-0">
                                        <table class="table table-hover text-nowrap">
                                            <thead>
                                                <tr>
                                                    <th>Friendly Name</th>
                                                    <th>Phone Number</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tollFreeNumbers">
                                            </tbody>
                                        </table>
                                    </div>
                                    <!-- /.card-body -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="access" role="tabpanel" aria-labelledby="access-tab">
                <!-- Content for Access Levels -->
                <div class="py-3 px-1">
                    <h3>Access Levels</h3>
                    <p>Content for Access Levels goes here...</p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="purchase_number_modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body">    
                <!-- <h4 id="admin_buy_number_message" style="display: none;">Do you really want to buy this number?</h4> -->
                <h4 id="dealer_buy_number_message" style="display: none;"></h4>
                <div class="form-group" id="buy_number_property_menu" style="display: none;">
                    <label>Properties</label>
                    <select name="property_id" id="buy_number_for_property" class="form-control select2bs4" style="width: 100%;" required></select>
                </div>
                <input type="hidden" name="user_role_number" id="number_user_layer" value="<?php echo $_SESSION['layer'] ?>" >
                <div class="modal-footer">
                    <input type="hidden" id="puchase_number_val" name="puchase_number_val">
                    <input type="hidden" id="sg_number_type" name="sg_number_type">
                    <button type="button" onclick="purchase_number()" class="btn btn-primary">Confirm</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="dealer_assign_number" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">Assign Number</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                
                    <div class="form-group">
                        <label>Phone Number</label>
                        <input type="text" name="phone_number" id="assign_dealer_number" class="form-control" disabled="">
                    </div>
                    <div class="form-group">
                        <label>Dealers</label>
                        <select name="dealer_id" id="numbers_dealers" class="form-control select2bs4" onchange="dealer_properties(this.value)" style="width: 100%;" required></select>
                    </div>
                    <div class="form-group">
                        <label>Property</label>
                        <select name="property_id" id="dealer_properties" class="form-control select2bs4" style="width: 100%;" required></select>
                    </div>
                    <input type="hidden" name="number_id" id="assign_number_id">
                    <div class="modal-footer">
                        <button type="button" name="assign" onclick="assignNumerToDealer()" class="btn btn-primary">Assign</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    </div>
                </form>  
            </div> 
        </div>
    </div>
</div>

<div class="modal fade" id="delete_number_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">Release Number</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                    <p>Are you sure you want to release your number</p>
                    <p class="text-center" id="delete_sg_number"></p>
                    <div class="modal-footer">
                        <input type="hidden" name="delete_number_val" id="delete_number_val">
                        <button type="button" name="assign" onclick="delete_number()" class="btn btn-danger">Release Number</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    </div>
                </form>  
            </div> 
        </div>
    </div>
</div>