<?php

    try {
        session_start();

        require '../../db.php';
        require '../auth/auth_functions.php';
        include_once __DIR__ .'/../../include/helper_functions/data_request.php';
        
        // if (!currentUserHasAccess($pdo, 'visitors', 'read')) {
        //     echo "Access denied.";
        //     // echo '<meta http-equiv="refresh" content="2">';
        //     exit();
        // }
        
        if (!currentUserHasAccess($pdo, 'visitors', 'read')) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Access denied! Please wait while being Re-Directed.',
                'redirect' => '../../dashboard.php'
            ]);
            exit();
        }

        $propertyId = $_SESSION['property'] ?? null;
        $primary_doors = fetchData('gate_doors', ['property_id' => $propertyId, 'is_primary' => 1]);

    } catch (\Throwable $th) {
        // throw $th;
    }

?>

<div>
    
    <script src="/js/cards_responsive/vendors.js"></script>

    <div class="d-flex justify-content-between align-items-center">
        <div>
            <button type="button" id="addvisitor" class="btn btn-dark" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#visitormodal" style="margin:1rem 0 1rem .5rem;width:auto;">+ Invisible Key</button>
            <?php if ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin' || $_SESSION['layer'] === 'dealer' || $_SESSION['layer'] === 'sub_dealer' || $_SESSION['layer'] === 'organization admin' || $_SESSION['layer'] === 'property admin'): ?>
            <button type="button" id="addvendor" class="btn btn-dark" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#vendormodal" style="margin:1rem 0 1rem .5rem;width:auto;">+ New Vendor</button>
            <?php endif; ?>
        </div>
    </div>
    <?php  ?>
    <!-- visitors card view start  -->
    <div class="" id="visitors_card_container" style="display:none">
        <div class="d-flex justify-content-between">
            <h5>Visitors</h5>
            <div class="card-tools">
                <div class="input-group input-group-sm" style="width: 250px;">
                    <input type="text" id="searchVisitorsUsersInput" onkeyup="searchVisitorsCard()" class="form-control float-right" placeholder="Search Visitors">
                    <div class="input-group-append">
                        <button type="button" class="btn btn-default">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="">
            <div class="d-flex flex-wrap" id="visitors_card_view">
            </div>
        </div>
    </div>
    <!-- visitors card view end  -->

    <div class="col-12" id="visitors_table_container" style="display:none">
        <div class="row">
            <div class="col-12" style="margin-top: 20px;">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Visitors</h3>
                        <!-- Search bar -->
                        <div class="card-tools">
                            <div class="input-group input-group-sm" style="width: 250px;">
                                <input type="text" id="searchVisitorsInput" onkeyup="searchTable('visitorsTable', 'searchVisitorsInput')" class="form-control float-right" placeholder="Search Visitors">
                                <div class="input-group-append">
                                    <button type="button" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover" id="visitorsTable">
                                <thead>
                                    <tr>
                                        <th>Visitor Name</th>
                                        <!-- <th>Door Name</th> -->
                                        <th>Key Type</th>
                                        <th>Status</th>

                                        <?php 
                                        $showCreatedBy = in_array($_SESSION['layer'], ['super_admin', 'admin', 'dealer', 'sub_dealer', 'organization admin', 'property admin']);
                                        $showProperty = in_array($_SESSION['layer'], ['super_admin', 'admin', 'dealer', 'sub_dealer', 'organization admin']);
                                        ?>

                                        <?php if ($showCreatedBy): ?>
                                            <th>Created By</th>
                                        <?php endif; ?>

                                        <?php if ($showProperty): ?>
                                            <th>Property</th>
                                        <?php endif; ?>

                                        <th>Edit</th>
                                    </tr>
                                </thead>
                                <tbody id="visitorsTableBody"></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- /.row -->
    <!-- <input type="hidden" id="session_layer_name" value="" name="session_layer_name"> -->
    <input type="hidden" id="session_layer_name" name="session_layer_name" value="<?php echo htmlspecialchars($_SESSION['layer'], ENT_QUOTES, 'UTF-8'); ?>">
    <?php if ($_SESSION['layer'] === 'super_admin' || $_SESSION['layer'] === 'admin' || $_SESSION['layer'] === 'dealer' || $_SESSION['layer'] === 'sub_dealer' || $_SESSION['layer'] === 'organization admin' || $_SESSION['layer'] === 'property admin'): ?>

        <!-- visitors card view start  -->
        <div class="mt-3" id="vendors_card_container" style="display:none">
            <div class="d-flex justify-content-between">
                <h5>Vendors</h5>
                <div class="card-tools">
                    <div class="input-group input-group-sm" style="width: 250px;">
                        <input type="text" id="searchCardsVendorsInput" onkeyup="searchVendorsCard()" class="form-control float-right" placeholder="Search Vendors">
                        <div class="input-group-append">
                            <button type="button" class="btn btn-default">
                                <i class="fas fa-search"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="">
                <div class="d-flex flex-wrap" id="vendors_card_view">
                </div>
            </div>
        </div>
        <!-- visitors card view end  -->

        <div class="col-12" id="vendors_table_container" style="display:none">
            <div class="row">
                <div class="col-12" style="margin-top: 20px;">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Vendors</h3>
                            <!-- Search bar for Vendors -->
                            <div class="card-tools">
                                <div class="input-group input-group-sm" style="width: 250px;">
                                    <input type="text" id="searchVendorsInput" onkeyup="searchTable('vendorsTable', 'searchVendorsInput')" class="form-control float-right" placeholder="Search Vendors">
                                    <div class="input-group-append">
                                        <button type="button" class="btn btn-default">
                                            <i class="fas fa-search"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- ./card-header -->
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover" id="vendorsTable">
                                    <thead>
                                        <tr>
                                            <th>Company</th>
                                            <th>Vendor Name</th>
                                            <!-- <th>Door Name</th> -->
                                            <th>Key Type</th>
                                            <th>Status</th>
                                            <th>Created By</th>
                                            <th>Property</th>
                                            <th>Edit</th>
                                        </tr>
                                    </thead>
                                    <tbody id='vendorsTableBody'></tbody>
                                </table>
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- /.row -->
    <div class="modal fade" id="visitormodal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalCenterTitle">New Invisible Key</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="invisibleKeyForm" action="include/visitors/visitors.php" method="post">

                        <input type="hidden" id="visitorId" name="visitorId">

                        <div class="input-group mb-3">
                            <input id="visitorName" name ="visitorName" class="form-control" placeholder="Enter Visitor Name" required>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Visitor Name"></span>
                                </div>
                            </div>
                        </div>
                        
                        <!-- <div class="input-group mb-3">
                            <select id="visitor_door" name ="door_id" class="form-control" required>
                                <option disabled selected value="">Please Select a door</option>
                            </select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-door-open" title="Type of Key"></span>
                                </div>
                            </div>
                        </div> -->

                        <div class="input-group mb-3">
                            <select id="keytypelist" name ="keytypeList" class="form-control" required>
                                <option disabled selected>Please Select a Key Type</option>
                            </select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-right-to-bracket" title="Type of Key"></span>
                                </div>
                            </div>
                        </div>

                        <div id="keytypeelements"></div>
                        
                        <div class="input-group mb-3">
                            <select id="keymode" name="keymode" class="form-control" required>
                                <option disabled selected>Please Select a Key Mode</option>
                                <option value="uses">Uses</option>
                                <option value="date">Date Only</option>
                                <option value="time">Time Only</option>
                                <option value="date_time">Date and Time</option>
                                <option value="schedule">Schedule</option>
                            </select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-regular fa-clock" title="Mode of Key"></span>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3" id="dynamic-form-elements"></div>
                        <div class="input-group mb-3" id="key_send_to_visitor">
                            <div class="icheck-primary">
                                <input type="checkbox" name="visitor_message" id="visitorMessageCheckBox" value="1" onclick="send_code_to_visitor()">
                                <label for="visitorMessageCheckBox">
                                    Send to Visitor
                                    <span class="ml-5">Doors : </span>
                                    <?php 
                                        $count = 1;
                                        foreach ($primary_doors as $p_door) { ?>

                                            <span>
                                                <?php echo "(" . $p_door['door_name'] . ")"; ?>
                                            </span>
                                            
                                    <?php $count++; } ?>
                                    
                                </label>
                            </div>

                        </div>
                        
                        <div id="key_visitor_number_field">
                        </div>

                        <button type="button" onclick="add_new_invisible_key()" class="btn btn-primary btn-block">Create Invisible Key</button>
                    </form>
                </div>
            </div> 
        </div>
    </div>

    <div class="modal fade" id="visitorupdatemodal" tabindex="-1" role="dialog" aria-labelledby="visitorupdateTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="visitorupdateTitle">View Invisible Key</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- Main content -->
                    <form id="invisibleKeyUpdateForm" action="include/visitors/visitors.php" method="post">

                        <input type="hidden" id="uvisitorId" name="uvisitorId">

                        <div class="input-group mb-3">
                            <input id="uvisitorName" name ="uvisitorName" class="form-control" placeholder="Enter Name" title="Visitor Name" disabled>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Visitor Name"></span>
                                </div>
                            </div>
                        </div>

                        <!-- <div class="input-group mb-3">
                            <select id="uvisitor_door" name ="door_id" class="form-control" required disabled="">
                                <option disabled selected value="">Please Select a door</option>
                            </select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-door-open" title="Type of Key"></span>
                                </div>
                            </div>
                        </div> -->
                        
                        <div class="input-group mb-3">
                            <select id="ukeytypelist" name ="ukeytypeList" class="form-control" placeholder="Please Select KeyType" title="Type of Key" disabled>
                                <option disabled selected>Please Select</option>
                            </select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-right-to-bracket" title="Type of Key"></span>
                                </div>
                            </div>
                        </div>

                        <div class="input-group mb-3" id="ukeytypeelements"></div>
                        
                        <div class="input-group mb-3">
                            <select id="ukeymode" name="ukeymode" class="form-control" placeholder="Please Select KeyMode" title="Mode of Key" disabled>
                                <option disabled selected>Please Select</option>
                                <option value="uses">Uses</option>
                                <option value="date">Date Only</option>
                                <option value="time">Time Only</option>
                                <option value="date_time">Date and Time</option>
                                <option value="schedule">Schedule</option>
                            </select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-regular fa-clock" title="Mode of Key"></span>
                                </div>
                            </div>
                        </div>

                        <div class="input-group mb-3" id="udynamic-form-elements"></div>
                        <div class="input-group">
                            <label>
                                <span class="badge badge-primary showHide" id="remianing_uses"></span>
                                <span class="ml-5">Doors : </span>
                                <?php 
                                    $count = 1;

                                    foreach ($primary_doors as $p_door) { ?>

                                        <span>
                                            <?php echo "(" . $p_door['door_name'] . ")"; ?>
                                        </span>
                                        
                                <?php $count++; } ?>
                            </label>
                        </div>

                        <!-- <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button> -->
                        <!-- <button type="submit" name="updateVisitorBtn" class="btn btn-primary btn-block">Update Invisible Key</button> -->
                    </form>

                </div> 
            </div>
        </div>
    </div>

    <div class="modal fade" id="vendormodal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalCenterTitle">Create a New Vendor</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                        <form id="vendorKeyForm" action="include/visitors/visitors.php" method="post">

                            <input type="hidden" id="vendorId" name="vendorId">

                            <div class="input-group mb-3">
                                <input id="vendorCompany" name ="vendorCompany" class="form-control" placeholder="Please Enter Company Name" title="Company Name" required>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fa-solid fa-address-card" title="Company Name"></span>
                                    </div>
                                </div>
                            </div>

                            <div class="input-group mb-3">
                                <input id="vendorName" name ="vendorName" class="form-control" placeholder="Please Enter Vendor Name" title="Vendor Name" required>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fa-solid fa-address-card" title="Vendor Name"></span>
                                    </div>
                                </div>
                            </div>
                            <!-- <div class="input-group mb-3">
                                <select id="vendor_door" name ="door_id" class="form-control" required>
                                    <option disabled selected value="">Please Select a door</option>
                                </select>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fa-solid fa-door-open" title="Type of Key"></span>
                                    </div>
                                </div>
                            </div> -->
                            
                            <div class="input-group mb-3">
                                <select id="keytypelist1" name ="keytypeList1" class="form-control" title="Type of Key" required>
                                    <option disabled selected>Please Select a Key Type</option>
                                </select>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fa-solid fa-right-to-bracket" title="Type of Key"></span>
                                    </div>
                                </div>
                            </div>

                            <div class="input-group mb-3" id="keytypeelements1"></div>
                            
                            <div class="input-group mb-3">
                                <select id="keymode1" name="keymode1" class="form-control" title="Mode of Key" required>
                                    <option disabled selected>Please Select a Key Mode</option>
                                    <option value="uses">Uses</option>
                                    <option value="date">Date Only</option>
                                    <option value="time">Time Only</option>
                                    <option value="date_time">Date and Time</option>
                                    <option value="schedule">Schedule</option>
                                </select>
                                <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-regular fa-clock" title="Mode of Key"></span>
                                </div>
                            </div>
                            </div>

                            <div class="input-group mb-3" id="dynamic-form-elements1"></div>
                            <div class="input-group mb-3" id="key_send_to_visitor">
                                <div class="icheck-primary d-inline">
                                    <input type="checkbox" name="vendor_message" id="vendorMessageCheckBox" value="1" onclick="send_code_to_vendor()">
                                    <label for="vendorMessageCheckBox">
                                        Send to Visitor
                                        <span class="ml-5">Doors : </span>
                                        <?php 
                                            $count = 1;
                                            foreach ($primary_doors as $p_door) { ?>

                                                <span>
                                                    <?php echo "(" . $p_door['door_name'] . ")"; ?>
                                                </span>
                                                
                                        <?php $count++; } ?>
                                    </label>
                                </div>
                            </div>
                            <!-- <div class="input-group mb-3" >
                                <p for="vendorMessageCheckBox">
                                    Send to Visitor
                                </p>
                            </div> -->
                            <div id="key_vendor_number_field">
                            </div>

                            <button type="button" onclick="add_new_vendor_key()" class="btn btn-primary btn-block">Create Invisible Key</button>
                        </form>
                    </div>
                </div> 
            </div>
        </div>
    </div>

    <div class="modal fade" id="vendorUpdatemodal" tabindex="-1" role="dialog" aria-labelledby="vendorUpdateTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="vendorUpdateTitle">View Vendor Key</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="uinvisibleKeyVendorForm" action="include/visitors/visitors.php" method="post">
                        
                        <input type="hidden" id="uvendorId" name="uvendorId">

                        <div class="input-group mb-3">
                            <input id="uvendorCompany" name ="uvendorCompany" class="form-control" title="Company Name" placeholder="Enter Company Name" disabled>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Company Name"></span>
                                </div>
                            </div>
                        </div>

                        <div class="input-group mb-3">
                            <input id="uvendorName" name ="uvendorName" class="form-control" title="Vendor Name" placeholder="Enter Vendor Name" disabled>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-address-card" title="Vendor Name"></span>
                                </div>
                            </div>
                        </div>

                        <!-- <div class="input-group mb-3">
                            <select id="uvendor_door" name ="door_id" class="form-control" required disabled>
                                <option disabled selected value="">Please Select a door</option>
                            </select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-door-open" title="Type of Key"></span>
                                </div>
                            </div>
                        </div> -->
                        
                        <div class="input-group mb-3">
                            <select name ="ukeytypeList1" id="ukeytypeList12" class="form-control" title="Type of Key" placeholder="Please Select KeyType" disabled>
                                <option disabled selected>Please Select</option>
                            </select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-solid fa-right-to-bracket" title="Type of Key"></span>
                                </div>
                            </div>
                        </div>

                        <div class="input-group mb-3" id="ukeytypeelements1"></div>
                        
                        <div class="input-group mb-3">
                            <select id="ukeymode1" name="ukeymode1" class="form-control" title="Mode of Key" placeholder="Please Select KeyMode" disabled>
                                <option disabled selected>Please Select</option>
                                <option value="uses">Uses</option>
                                <option value="date">Date Only</option>
                                <option value="time">Time Only</option>
                                <option value="date_time">Date and Time</option>
                                <option value="schedule">Schedule</option>
                            </select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fa-regular fa-clock" title="Mode of Key"></span>
                                </div>
                            </div>
                        </div>

                        <div class="input-group mb-3" id="udynamic-form-elements1"></div>
                        <div class="input-group mb-3">
                            <label>
                                <span class="badge badge-primary showHide" id="vremianing_uses">
                                    
                                </span>
                                <span class="ml-5">Doors : </span>
                                <?php 
                                    $count = 1;
                                    foreach ($primary_doors as $p_door) { ?>

                                        <span>
                                            <?php echo "(" . $p_door['door_name'] . ")"; ?>
                                        </span>
                                        
                                <?php $count++; } ?>
                            </label>
                        </div>
                        
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <!-- <button type="submit" name="updateVendorBtn" class="btn btn-primary btn-block">Update Invisible Key</button> -->
                    </form>
                </div> 
            </div>
        </div>
    </div>
</div>