function formatPhoneNumber(input) {

    let cleaned = input.value.replace(/[^0-9]/g, "");
    cleaned = cleaned.slice(0, 10);

    let formatted = "";
    if (cleaned.length > 0) {
        formatted = "(" + cleaned.substring(0, 3) + ") ";
    }
    if (cleaned.length > 3) {
        formatted += cleaned.substring(3, 6);
    }
    if (cleaned.length > 6) {
        formatted += "-" + cleaned.substring(6, 10);
    }

    input.value = formatted;
}

function handlePaste(event) {

    event.preventDefault();

    const pastedData = (event.clipboardData || window.clipboardData).getData("text");

    let cleaned = pastedData.replace(/[^0-9]/g, "");
    cleaned = cleaned.slice(0, 10);

    let formatted = "";
    if (cleaned.length > 0) {
        formatted = "(" + cleaned.substring(0, 3) + ") ";
    }
    if (cleaned.length > 3) {
        formatted += cleaned.substring(3, 6);
    }
    if (cleaned.length > 6) {
        formatted += "-" + cleaned.substring(6, 10);
    }

    event.target.value = formatted;
}

document.getElementById('registerForm').addEventListener('submit', function (event) {
    const password = document.getElementById('pwd').value;
    const confirmPassword = document.getElementById('pwdc').value;
    const passwordError = document.getElementById('passwordError');

    // Need to enable before live
    // const passwordPattern = /^(?=.*[A-Z])(?=.*\d)(?=.*[!@#$%^&*()_+|~=`{}\[\]:";'<>,.\/]).{8,}$/;
    const passwordPattern = /(?=.*\d).{4,}/;

    if (password !== confirmPassword) {
        event.preventDefault();
        passwordError.textContent = "Passwords do not match.";
        passwordError.style.display = "block";
    } else if (!passwordPattern.test(password)) {
        event.preventDefault();
        passwordError.textContent = "Password must be at least 8 characters, include 1 uppercase letter, 1 number, and 1 special character.";
        passwordError.style.display = "block";
    } else {
        passwordError.style.display = "none";
    }
});

const passwordField = document.getElementById('pwd');
const passwordStrength = document.getElementById('passwordStrength');
const passwordStrengthText = document.getElementById('passwordStrengthText');

passwordField.addEventListener('input', function () {
    const value = passwordField.value;
    let strength = 0;
    let strengthText = "Too Short";

    // Need to enable before live
    // if (value.length >= 8) strength += 25; 
    // if (/[A-Z]/.test(value)) strength += 25; 
    // if (/\d/.test(value)) strength += 25; 
    // if (/[!@#$%^&*()_+|~=`{}\[\]:";'<>,.\/]/.test(value)) strength += 25; 
    if (value.length >= 4) strength += 25; 
    if (/[1]/g.test(value)) strength += 25; 
    if (/[2]/g.test(value)) strength += 25; 
    if (/[3]/g.test(value)) strength += 25;

    passwordStrength.value = strength;
    passwordStrength.style.width = strength + "%";

    passwordStrength.classList.remove('weak', 'moderate', 'strong', 'very-strong');
    passwordStrengthText.classList.remove('weak-text', 'moderate-text', 'strong-text', 'very-strong-text');

    if (strength === 0) {
        strengthText = "";
    } else if (strength <= 25) {
        passwordStrength.classList.add('weak');
        passwordStrengthText.classList.add('weak-text');
        strengthText = "Weak";
    } else if (strength <= 50) {
        passwordStrength.classList.add('moderate');
        passwordStrengthText.classList.add('moderate-text');
        strengthText = "Moderate";
    } else if (strength <= 75) {
        passwordStrength.classList.add('strong');
        passwordStrengthText.classList.add('strong-text');
        strengthText = "Strong";
    } else if (strength === 100) {
        passwordStrength.classList.add('very-strong');
        passwordStrengthText.classList.add('very-strong-text');
        strengthText = "Very Strong";
    }

    passwordStrengthText.textContent = strengthText;
});
