<?php

class Migration_20240712000016_update_role_resources_tbl
{
    public static function up(PDO $pdo)
    {
        $roles = [
            'super_admin' => [
                'admin_panel' => ['read', 'write', 'delete'],
                'admin_setup' => ['read', 'write', 'delete'],
                'dashboard' => ['read', 'write', 'delete'],
                'my_iis' => ['read', 'write', 'delete'],
                'my_properties' => ['read', 'write', 'delete'],
                'property' => ['read', 'write', 'delete'],
                'integrations' => ['read', 'write', 'delete'],
                'my_roles' => ['read', 'write', 'delete'],
                'users' => ['read', 'write', 'delete'],
                'settings' => ['read', 'write', 'delete'],
                'payment_invoice' => ['read', 'write', 'delete']
            ],
            'admin' => [
                'dealer_setup' => ['read', 'write', 'delete'],
                'dashboard' => ['read', 'write'],
                'my_iis' => ['read', 'write', 'delete'],
                'my_properties' => ['read', 'write', 'delete'],
                'property' => ['read', 'write', 'delete'],
                'integrations' => ['read', 'write', 'delete'],
                'my_roles' => ['read', 'write', 'delete'],
                'users' => ['read', 'write', 'delete'],
                'settings' => ['read', 'write', 'delete'],
                'payment_invoice' => ['read', 'write', 'delete']
            ],
            'dealer' => [
                'dashboard' => ['read'],
                'my_iis' => ['read'],
                'my_properties' => ['read', 'write'],
                'property' => ['read', 'write'],
                'integrations' => ['read', 'write'],
                'my_roles' => ['read', 'write', 'delete'],
                'users' => ['read', 'write', 'delete'],
                'settings' => ['read', 'write'],
                'payment_invoice' => ['read', 'write']
            ],
            'organization admin' => [
                'dashboard' => ['read'],
                'my_iis' => ['read'],
                'my_properties' => ['read', 'write'],
                'property' => ['read', 'write'],
                'integrations' => ['read'],
                'my_roles' => ['read', 'write', 'delete'],
                'users' => ['read', 'write', 'delete'],
                'settings' => ['read', 'write'],
                'payment_invoice' => ['read', 'write']
            ],
            'property admin' => [
                'dashboard' => ['read'],
                'my_iis' => ['read'],
                'property' => ['read', 'write'],
                'integrations' => ['read'],
                'my_roles' => ['read', 'write', 'delete'],
                'users' => ['read', 'write', 'delete'],
                'visitors' => ['read', 'write', 'delete'],
                'command_center' => ['read', 'write'],
                'events' => ['read'],
                'payment_invoice' => ['read'],
                'settings' => ['read']
            ],
            'user' => [
                'dashboard' => ['read'],
                'visitors' => ['read', 'write', 'delete'],
                'command_center' => ['read'],
                'events' => ['read']
            ]
        ];

        $sql = '';

        foreach ($roles as $role => $resources) {
            foreach ($resources as $resource => $actions) {
                $sql .= "
                    DELETE FROM role_resources
                    WHERE role_id = (SELECT id FROM roles WHERE name = '$role')
                    AND resource_id = (SELECT id FROM resources WHERE name = '$resource');
                ";

                foreach ($actions as $action) {
                    $sql .= "
                        INSERT INTO role_resources (role_id, resource_id, action_id)
                        VALUES (
                            (SELECT id FROM roles WHERE name = '$role'),
                            (SELECT id FROM resources WHERE name = '$resource'),
                            (SELECT id FROM actions WHERE name = '$action')
                        );\n";
                }
            }
        }

        $pdo->exec($sql);
    }

    public static function down(PDO $pdo)
    {
        $sql = "
            DELETE FROM role_resources;
        ";

        $pdo->exec($sql);
    }
}
