<?php

class Migration_20241212111721_alter_table_calendar_events
{
    public static function up(PDO $pdo)
    {
        // Add columns to `calendar_added_events`
        $sql_add_columns_calendar_added_events = "
            ALTER TABLE `calendar_added_events`
            ADD COLUMN `property_id` INT AFTER `borderColor`,
            ADD COLUMN `schedule_type` VARCHAR(100) AFTER `property_id`,
            ADD COLUMN `event_detail` VARCHAR(100) AFTER `schedule_type`;
        ";
        $pdo->exec($sql_add_columns_calendar_added_events);

        // Add columns to `schedule_events`
        $sql_add_columns_schedule_events = "
            ALTER TABLE `schedule_events`
            ADD COLUMN `property_id` INT AFTER `isAllDay`,
            ADD COLUMN `event_detail` VARCHAR(100) AFTER `property_id`;
        ";
        $pdo->exec($sql_add_columns_schedule_events);
    }

    public static function down(PDO $pdo)
    {
        // Rollback columns for `calendar_added_events`
        $sql_remove_columns_calendar_added_events = "
            ALTER TABLE `calendar_added_events`
            DROP COLUMN `event_detail`,
            DROP COLUMN `property_id`;
        ";
        $pdo->exec($sql_remove_columns_calendar_added_events);

        // Rollback columns for `schedule_events`
        $sql_remove_columns_schedule_events = "
            ALTER TABLE `schedule_events`
            DROP COLUMN `event_detail`,
            DROP COLUMN `property_id`;
        ";
        $pdo->exec($sql_remove_columns_schedule_events);
    }
}
