<?php

class Migration_20250131021209_create_admin_tbl
{
    public static function up(PDO $pdo)
    {
        $sql = "
            CREATE TABLE IF NOT EXISTS `dealer_admins` (
                `id` INT AUTO_INCREMENT PRIMARY KEY,
                `firstname` VARCHAR(50) NOT NULL,
                `lastname` VARCHAR(50) NOT NULL,
                `password` VARCHAR(255) NOT NULL,
                `email` VARCHAR(100) NOT NULL UNIQUE,
                `layer` ENUM('sub_dealer', 'organization admin') NOT NULL,
                `status` ENUM('registered','not registered') NOT NULL,
                `dealer_assoc` INT NOT NULL,
                `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                `deleted_at` DATETIME DEFAULT NULL 
            );

            CREATE TABLE IF NOT EXISTS `dealer_admins_data` (
                `id` INT AUTO_INCREMENT PRIMARY KEY,
                `dealer_admins_id` INT NOT NULL,
                `mobile_number` VARCHAR(10) NOT NULL,
                `role` INT NOT NULL,
                `custom` INT NOT NULL,
                `created_by` INT NOT NULL,
                `creator_type` ENUM('users', 'property_users'),
                `photo_loc` INT NOT NULL,
                `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                `deleted_at` DATETIME DEFAULT NULL,
                FOREIGN KEY (photo_loc) REFERENCES profile_photo(id)
            );

            CREATE TABLE `dealer_admins_access` (
                `id` INT AUTO_INCREMENT PRIMARY KEY,
                `dealer_admin_id` INT NOT NULL,
                `access_type` ENUM('organization', 'property') NOT NULL,
                `access_id` INT NOT NULL,
                `assigned_by` INT NOT NULL,
                `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                `deleted_at` DATETIME DEFAULT NULL,
                FOREIGN KEY (dealer_admin_id) REFERENCES dealer_admins(id),
                FOREIGN KEY (assigned_by) REFERENCES users(id)
            );

        ";

        $pdo->exec($sql);
    }

    public static function down(PDO $pdo)
    {
        $sql = "
        DROP TABLE IF EXISTS dealer_admins_access;
        DROP TABLE IF EXISTS dealer_admins_data;
        DROP TABLE IF EXISTS dealer_admins;
        ";

        $pdo->exec($sql);
    }
}