<?php

class Migration_20250223005645_add_payment_menu_resources
{
    public static function up(PDO $pdo)
    {
        // Array of data to insert/update
        $data = [
            ['name' => 'payment_invoice', 'slug' => 'dashboard.php?tab=payment_invoice', 'dataPage' => 'Payment / Invoice', 'label' => 'Payment / Invoice', 'icon' => 'far fa-solid fa-dollar', 'parentId' => NULL, 'isChild' => ''],
        ];

        foreach ($data as $row) {
            $sql2 = "
                UPDATE resources SET 
                    slug = :slug, 
                    dataPage = :dataPage, 
                    label = :label, 
                    icon = :icon, 
                    parentId = :parentId, 
                    isChild = :isChild
                WHERE name = :name
            ";
            $stmt = $pdo->prepare($sql2);
            $stmt->execute([
                ':slug' => $row['slug'],
                ':dataPage' => $row['dataPage'],
                ':label' => $row['label'],
                ':icon' => $row['icon'],
                ':parentId' => $row['parentId'],
                ':isChild' => $row['isChild'],
                ':name' => $row['name'],
            ]);
        }

    }

    public static function down(PDO $pdo)
    {
        // Rollback the migration by dropping the columns (optional)
        $sql = "
            ALTER TABLE resources
            DROP COLUMN payment_invoice,
        ";
        $pdo->exec($sql);
    }
}