<?php

class Migration_20250314152749_alter_users_tables
{
    public static function up(PDO $pdo)
    {
        $tables = ['users', 'property_users', 'dealer_admins'];

        foreach ($tables as $table) {

            $pdo->exec("
                ALTER TABLE {$table} 
                DROP INDEX email;
            ");

            $pdo->exec("
                ALTER TABLE {$table} 
                ADD UNIQUE KEY unique_active_email (email, deleted_at);
            ");
        }
    }

    public static function down(PDO $pdo)
    {
        $tables = ['users', 'property_users', 'dealer_admins'];

        foreach ($tables as $table) {

            $pdo->exec("
                ALTER TABLE {$table} 
                DROP INDEX unique_active_email;
            ");

            $pdo->exec("
                ALTER TABLE {$table} 
                ADD UNIQUE KEY email (email);
            ");
        }
    }
}
