<?php

class Migration_20250901110456_automations_table
{
    public static function up(PDO $pdo)
    {
        $query = "DROP TABLE IF EXISTS hardware_automations;";
        $pdo->exec($query);
        $query = "
            CREATE TABLE IF NOT EXISTS hardware_automations (
                id INT AUTO_INCREMENT PRIMARY KEY,
                input VARCHAR(255) NOT NULL,
                input_status VARCHAR(255) NOT NULL,
                device_id INT NOT NULL,
                output VARCHAR(255) NOT NULL,
                triggered_by VARCHAR(255) NOT NULL,
                user_schedule VARCHAR(255) DEFAULT NULL,
                property_id INT NOT NULL,
                automation_rules_text TEXT NOT NULL,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                created_by_email varchar(255),
                CONSTRAINT fk_hardware_automations_device 
                    FOREIGN KEY (device_id) REFERENCES hardwares_settings(id)
                    ON DELETE CASCADE
            );
        ";
        $pdo->exec($query);
    }

    public static function down(PDO $pdo)
    {
        $query = "DROP TABLE IF EXISTS hardware_automations;";
        $pdo->exec($query);
    }
}