<?php

    try {
        session_start();

        include '../db.php';
        require '../include/auth/auth_functions.php';

        if (!currentUserHasAccess($pdo, 'integrations', 'read')) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Access denied! Please wait while being Re-Directed.',
                'redirect' => '../dashboard.php'
            ]);
            exit();
        }
    } catch (\Throwable $th) {
        // throw $th;
    }

?>

<div class="col-12">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Coming Soon</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
                        <li class="breadcrumb-item active">Coming Soon</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 text-center">
                    <div class="card card-warning shadow-sm">
                        <div class="card-body">
                            <i class="fas fa-tools fa-5x text-info mb-3"></i>
                            <h2 class="mb-3">We're Working on It!</h2>
                            <p class="lead">This feature is coming soon. Stay tuned for updates.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>