<?php

try {
    if (session_status() === PHP_SESSION_NONE) session_start();
    require "shared_essentials.php";
} catch (\Throwable $th) {
    // throw $th;
}
?>

<nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Left navbar links -->
    <ul id="sidebarToggle" class="navbar-nav">
        <li class="nav-item">
            <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
        </li>
    </ul>

    <div class="navbar d-flex align-items-center" id="main_header_property_container">
        <div class="input-group d-flex align-items-center">
            <meta name="csrf-token" content="<?php echo $_SESSION['csrf_token']; ?>">
            <label class="custom-label mr-2" id="main_header_property_label">Site:</label> <!--also have css to remove if not used -->
            <select id="selectproperty" class="form-control" style="font-size: 1rem;" name="selectProperty" required></select>
        </div>
    </div>

    <!-- Right navbar links -->
    <ul class="navbar-nav ml-auto">
        <!-- Navbar Search -->
        <!-- <li class="nav-item">
            <a class="nav-link" data-widget="navbar-search" href="#" role="button">
                <i class="fas fa-search"></i>
            </a>
            <div class="navbar-search-block">
                <form class="form-inline">
                    <div class="input-group input-group-sm">
                        <input class="form-control form-control-navbar" type="search" placeholder="Search" aria-label="Search">
                        <div class="input-group-append">
                            <button class="btn btn-navbar" type="submit">
                                <i class="fas fa-search"></i>
                            </button>
                            <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </li> -->

    </ul>

    <!-- Right user panel -->

    <li style="display: flex;justify-content: center;">
        <div class="form-group" style="display: none;margin-top: 4px;margin-bottom: 0px;padding: 0px 7px;" id="disturb_input_visibility">
            <label for="is_dont_disturb">Do Not Disturb:</label>
            <input type="checkbox" id="is_dont_disturb" data-on-text="On" data-size="small" data-off-text="Off" data-on-color="danger" data-off-color="success">
        </div>
    </li>
    <li style="display: flex;justify-content: center;">
        <a href="#" class="user-image-link" data-toggle="modal" data-target="#profilemodal">
            <div class="user_profile">
                <?php if (!empty($_SESSION['profile_image'])): ?>
                    <img src="/shared/serve_image.php?path=<?php echo urlencode($_SESSION['profile_image']); ?>&type=profile"
                        width="50" height="50" class="img-circle p-1 user_profile_avatar" alt="User Image">
                <?php elseif (!empty($_SESSION['avatar_icon'])): ?>
                    <i class="<?php echo htmlspecialchars($_SESSION['avatar_icon']); ?> fa-4x"></i>
                <?php else: ?>

                    <i class="fas fa-user-circle fa-4x"></i>
                <?php endif; ?>
            </div>
        </a>
    </li>

    <li class="nav-item dropdown list-group">
        <a id="dropdownSubMenu1" href="#" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" class="nav-link dropdown-toggle namelayer"><?php echo ucwords($_SESSION['name']); ?></a>
        <ul aria-labelledby="dropdownSubMenu1" class="dropdown-menu border-0 shadow dropdown-hover">
            <li style="display: flex;justify-content: center;">
                <a href="#" class="user-image-link">
                    <?php if (!empty($_SESSION['profile_image'])): ?>

                        <img src="/shared/serve_image.php?path=<?php echo urlencode($_SESSION['profile_image']); ?>&type=profile"
                            width="50" height="50" class="img-circle p-1" alt="User Image">
                    <?php elseif (!empty($_SESSION['avatar_icon'])): ?>

                        <i class="<?php echo htmlspecialchars($_SESSION['avatar_icon']); ?> fa-4x"></i>
                    <?php else: ?>

                        <i class="fas fa-user-circle fa-4x"></i>
                    <?php endif; ?>
                </a>
            </li>
            <li class="namelayer">
                <a>
                    <span class='layer'><?php $layer = $_SESSION['layer'];
                                        $layer = str_replace('_', ' ', $layer);
                                        $layer = ucwords($layer);
                                        echo $layer; ?></span>
                </a>
            </li>
            <li class="dropdown-divider"></li>
            <li>
                <a href="" data-toggle="modal" data-target="#profilemodal" class="dropdown-item">Profile</a>
            </li>
            <li>
                <a href="#" onclick="getPreferences()" class="dropdown-item">Preferences</a> <!--data-toggle="modal" data-target="#prefmodal"-->
            </li>
            <!-- <li>
                <a href="#" data-toggle="modal" data-target="#featuremodal" class="dropdown-item">Features</a>
            </li> -->

            <!-- Level two dropdown-->

            <!-- <li class="dropdown-divider"></li> -->
            
            <!-- <li class="dropdown-submenu dropdown-hover dropdown-menu-left">
                <a id="dropdownSubMenu2" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true" class="dropdown-item dropdown-toggle">Help</a>
                <ul aria-labelledby="dropdownSubMenu2" class="dropdown-menu border-0 shadow" style="left: -100%;">
                    <li>
                        <a href="#" class="dropdown-item">Documentation</a>
                    </li>
                    <li>
                        <a href="support_tickets.php" class="dropdown-item">Support Tickets</a>
                    </li>
                </ul>
            </li> -->
            <!-- End Level two -->
        </ul>
    </li>

    <div class="link">
        <a href="include/auth/logout.php" class="d-block">Logout</a>
    </div>
</nav>