<?php
    require_once('call_flow_functions.php');
    header('Content-Type: application/xml; charset=UTF-8');
    $message_url = "/shared/serve_audios.php?path=";

    $call_sid = htmlspecialchars($_POST['CallSid'] ?? '', ENT_QUOTES, 'UTF-8');
    $call_status = htmlspecialchars($_POST['CallStatus'] ?? '', ENT_QUOTES, 'UTF-8');
    $from_number = format_number($_REQUEST['From'] ?? '');
    $to_number = format_number($_REQUEST['To'] ?? '');
    $call_flow = get_call_flow($to_number);
    $base_url = htmlspecialchars(base_url(), ENT_QUOTES, 'UTF-8');

    $call_history = fetch_table_data('call_histories', 'call_sid', $call_sid);
    $call_id = $call_history['id'];
    $cnam = htmlspecialchars($call_history['cnam'] ?? '', ENT_QUOTES, 'UTF-8');

    $press2_access = defalt_voice_message("access_granted.wav");
    $press2_denied = defalt_voice_message("access_denied.wav");

    // $get_door = get_door($to_number);
    // if(!empty($call_history['door_id'])){
    //     $get_door = fetchDataSingle('gate_doors', ['id' => $call_history['door_id']]);
    // }
    // else{
        $get_door = get_door($to_number);
    // }

    if (!isset($_REQUEST['message_denied'])) {
        if (isset($call_flow['id'])) {
            if ($call_flow['press2_auth_code_access_default_message'] == 0) {
                $check_press2_access_messge = $call_flow['press2_auth_code_access_textto_speech'];
                if ($check_press2_access_messge == 0) {
                    $press2_access_message = $message_url . $call_flow['press2_auth_code_access_audio_file'];
                    $press2_access_message = urlencode($press2_access_message);
                    $press2_access = "<Play>$press2_access_message</Play>";
                } else {
                    $press2_access_message = htmlspecialchars($call_flow['press2_auth_code_access_text'], ENT_QUOTES, 'UTF-8');
                    $press2_auth_access_vocie_select = htmlspecialchars($call_flow['press2_auth_access_vocie_select'], ENT_QUOTES, 'UTF-8');
                    $press2_access = "<Say voice='" . $press2_auth_access_vocie_select . "'>$press2_access_message</Say>";
                }
            }

            if ($call_flow['press2_auth_code_denied_default_message']) {
                $press2_access_denied_message = $call_flow['press2_auth_code_denied_textto_speech'];
                if ($press2_access_denied_message == 0) {
                    $press2_denied_message = $message_url . $call_flow['press2_auth_code_denied_audio_file'];
                    $press2_denied_message = urlencode($press2_denied_message);
                    $press2_denied = "<Play>$press2_denied_message</Play>";
                } else {
                    $press2_denied_message = htmlspecialchars($call_flow['press2_auth_code_denied_text'], ENT_QUOTES, 'UTF-8');
                    $press2_auth_denied_vocie_select = htmlspecialchars($call_flow['press2_auth_denied_vocie_select'], ENT_QUOTES, 'UTF-8');
                    $press2_denied = "<Say voice='" . $press2_auth_denied_vocie_select . "'>$press2_denied_message</Say>";
                }
            }
        }

        $digit = $_REQUEST['digit'] ?? '';
        echo '<?xml version="1.0" encoding="UTF-8"?>';
        if ($digit == 1) {
            if ($get_door != 0) {
                $door_key = $get_door['id'];
                $request_open_door = request_open_door($call_id, "2", $get_door, $door_key, $call_history['to_number'], "door_id");

                $response_result = json_decode($request_open_door, true);
                if ($response_result['success'] == 1) {
                    echo "<Response>
                        $press2_access
                    </Response>";
                } else {
                    $response_text = htmlspecialchars($response_result['data'] ?? 'Unknown error', ENT_QUOTES, 'UTF-8'); // LINE 56 FIXED
                    $press2_access = "<Say>$response_text</Say>";
                    echo "<Response>
                        $press2_access
                    </Response>";
                }
            }
        } else {
            // LINE 62 FIXED
            $body = 'Access denied to caller "' . $call_sid . '" at "Main Gate"';
            echo "<Response>
                $press2_denied
            </Response>";
        }
    }

    // LINE 69 FIXED
    if (($call_flow['is_authorized_message'] ?? 0) == 1) {
        $door_name = htmlspecialchars($get_door['door_name'] ?? 'Unknown', ENT_QUOTES, 'UTF-8');
        $body = 'PIN **** was used to open the Gate by ' . $cnam . ' at "' . $door_name . '" - Reply stop to opt out';
        $messageSid = send_sms_to_owner($call_id, $to_number, $from_number, $body);
        // calculate_message_amount($call_id, $to_number, $messageSid);
    }

    if(empty($call_history['call_cost']) || $call_history['call_cost'] == 0){
        $first_call_sid = $call_history['call_sid'];
        $price = 0;
        if(!empty($first_call_sid)){
            $price = check_status($to_number, $first_call_sid, 'price');
            $deduct_cost = deduct_call_cost($call_history['id'], $call_history['property_id'], $price);
        }
    }
?>
