<?php
	function make_curl_request($type, $url, $method, $data="", $signalwire_credentials=[], $headers="") {
		if(($type == "socket") || ($type == "req_open_door") || (isset($signalwire_credentials['id']) && !empty($signalwire_credentials['id']))){
			if(($type != "socket") && ($type != "req_open_door")){
				$space_url = $signalwire_credentials['space_url'];
				$project_id = $signalwire_credentials['project_id'];
				$api_token = $signalwire_credentials['api_token'];
			}
				
			// Initialize cURL
		    $ch = curl_init($url);
		    if($type == "remove_participant"){
		    	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
		    }
		    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		    if(!empty($headers)){
		    	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		    }
		    if($type == "status_check"){
		    	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
		    }
		    if($method == "post"){
		    	curl_setopt($ch, CURLOPT_POST, true);
		    }
		    else{
		    	curl_setopt($ch, CURLOPT_POST, false);	
		    }
		    if(!empty($data)){
		    	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
		    }
		    if(($type != "socket") && ($type != "req_open_door")){
		    	curl_setopt($ch, CURLOPT_USERPWD, "$project_id:$api_token");
		    }
		    $response = curl_exec($ch);
		    curl_close($ch);		   
		    return $response;
		}

		
	}

	$url = "https://testinvisiblessl.myagecam.net/include/property_builder/doors/open_door.php";
	// Initialize cURL
	$data = [
				'door_id' => 2,
	    		'flag_bit' => 'door_id',
			];
	$response = make_curl_request("req_open_door", $url, "post", $data);
	print_r($response);

?>