const express = require('express');
const cors = require('cors');
const http = require('http');
const app = express();
const port = 3002;
const { webSocketServers } = require('./controllers'); // Import webSocketServers

app.use(cors({
    origin: '*',
    methods: ['GET', 'POST', 'PUT', 'DELETE'],
    allowedHeaders: ['Content-Type', 'Authorization']
}));
app.use(express.json());

// Import the router
const apiRouter = require('./routers');
app.use(apiRouter);

const server = http.createServer(app);

server.on('upgrade', (request, socket, head) => {
    const uniqueId = new URL(request.url, `http://${request.headers.host}`).searchParams.get('id');
    if (webSocketServers[uniqueId]) {
        webSocketServers[uniqueId].handleUpgrade(request, socket, head, (ws) => {
            webSocketServers[uniqueId].emit('connection', ws, request);
        });
    } else {
        socket.destroy();
    }
});

server.listen(port, () => {
    console.log(`Server is running at http://localhost:${port}`);
});
